
#include "Perus.h"


void GRAFIIKKA::TulostaTeksti( TEKSTI &T, double X, double Y, HIIRI Hiiri, KESKITYSTAPA KeskitysTapa, int Fontti, double KokoKerroin )
{
    double *KokoRivinLeveys = new double [T.RivejaKaytossa];
    double *RivinLeveys = new double [T.RivejaKaytossa];
    
    for(int i=0; i<T.RivejaKaytossa; i++){ KokoRivinLeveys[i] = 0; RivinLeveys[i] = 0; }
    
    for(int i=0; i<T.KirjaimiaKaytossa; i++)
        KokoRivinLeveys[T.EnkoodattuTeksti[i].Rivi] += Fontit[Fontti].Kirjaimet[T.EnkoodattuTeksti[i].Ind].Leveys * KokoKerroin;

    double *WKeskitys = new double [T.RivejaKaytossa];
    double HKeskitys;
    for(int i=0; i<T.RivejaKaytossa; i++)
    {
        switch(KeskitysTapa)
        {
            case AlaVasen: case KeskiVasen: case YlaVasen:
                WKeskitys[i] = 0;                       break;
                
            case AlaKeski: case KeskiKeski: case YlaKeski:
                WKeskitys[i] = -KokoRivinLeveys[i]/2;    break;
            
            case AlaOikea: case KeskiOikea: case YlaOikea:
                WKeskitys[i] = -KokoRivinLeveys[i];      break;
        }
    }
    switch(KeskitysTapa)
    {
        case AlaVasen: case AlaKeski: case AlaOikea:
            HKeskitys = 0;                                                        break;
                
        case KeskiVasen: case KeskiKeski: case KeskiOikea:
            HKeskitys = -T.RivejaKaytossa * Fontit[Fontti].Kirjaimet[0].Korkeus * KokoKerroin/2;   break;
            
        case YlaVasen: case YlaKeski: case YlaOikea:
            HKeskitys = -T.RivejaKaytossa * Fontit[Fontti].Kirjaimet[0].Korkeus * KokoKerroin;     break;
    }
    
    
    VARI KirjaimenVari = ColTeksti;
    int KohdistusTapahtunut = -1; 
    int AktiivinenRivi = -1; int AktiivinenKohta = -1;
    for(int i=0; i<T.KirjaimiaKaytossa; i++)
    {
        double KirjaimenX = X + RivinLeveys[T.EnkoodattuTeksti[i].Rivi] + WKeskitys[T.EnkoodattuTeksti[i].Rivi];
        double KirjaimenY = Y + (T.RivejaKaytossa - T.EnkoodattuTeksti[i].Rivi -1) * Fontit[Fontti].Kirjaimet[0].Korkeus * KokoKerroin + HKeskitys;
        double KirjaimenLeveys = Fontit[Fontti].Kirjaimet[T.EnkoodattuTeksti[i].Ind].Leveys * KokoKerroin;
        double KirjaimenKorkeus = Fontit[Fontti].Kirjaimet[0].Korkeus * KokoKerroin;
        RivinLeveys[T.EnkoodattuTeksti[i].Rivi] += KirjaimenLeveys;
        VARI KirjaimenVari = ColTeksti;
        
        if(T.EnkoodattuTeksti[i].Rivi != AktiivinenRivi || T.EnkoodattuTeksti[i].Kohta != AktiivinenKohta)
        { KohdistusTapahtunut = -1; KirjaimenVari = ColTeksti; AktiivinenRivi = -1; AktiivinenKohta = -1;}
        
        if(KohdistusTapahtunut == -1 && Hiiri.OnkoSisalla( KirjaimenX, KirjaimenY, KirjaimenLeveys, KirjaimenKorkeus))
        {
            if(Hiiri.NapinTila(BUT_LEFT) == Pohjassa) KirjaimenVari = ColKohdistettuKirjain;
            
            for(int n=0; n<T.ValittaviaKohtiaKaytossa; n++)
            {
                if(T.ValittavaKohta[n].Rivi == T.EnkoodattuTeksti[i].Rivi 
                && T.ValittavaKohta[n].Kohta == T.EnkoodattuTeksti[i].Kohta)
                {
                    KohdistusTapahtunut = i;
                    AktiivinenRivi = T.EnkoodattuTeksti[i].Rivi; 
                    AktiivinenKohta = T.EnkoodattuTeksti[i].Kohta;
                    //KirjaimenVari = ColKohdistettuVTeksti;
                    int KirjainKohdistettuApu = i;
            
                    RivinLeveys[T.EnkoodattuTeksti[i].Rivi] -= KirjaimenLeveys;
                    i--;
                    while( T.EnkoodattuTeksti[i].Rivi == AktiivinenRivi && T.EnkoodattuTeksti[i].Kohta == AktiivinenKohta ) 
                    {
                        PoistaKuva();
                        RivinLeveys[T.EnkoodattuTeksti[i].Rivi] -= Fontit[Fontti].Kirjaimet[T.EnkoodattuTeksti[i].Ind].Leveys * KokoKerroin;
                        i--;
                    }
                    T.ValittavaKohta[n].KirjainKohdistettu = KirjainKohdistettuApu - i;
                }
            }
            if(KohdistusTapahtunut > -1) continue;
        }
        if(KohdistusTapahtunut > -1) KirjaimenVari = ColKohdistettuVTeksti;
        if(KohdistusTapahtunut == i) KirjaimenVari = ColKohdistettuVKirjain;
        
        LisaaKuva( Fontit[Fontti].Kirjaimet[T.EnkoodattuTeksti[i].Ind], KirjaimenX, KirjaimenY, KokoKerroin, KirjaimenVari );
        
    }
    
    delete [] WKeskitys;
    delete [] KokoRivinLeveys;
    delete [] RivinLeveys;

    delete [] T.EnkoodattuTeksti; T.EnkoodattuTeksti = NULL;
}




void GRAFIIKKA::TulostaTeksti( TEKSTI &T, double X, double Y, KESKITYSTAPA KeskitysTapa, int Fontti, double KokoKerroin )
{
    double *KokoRivinLeveys = new double [T.RivejaKaytossa];
    double *RivinLeveys = new double [T.RivejaKaytossa];
    
    for(int i=0; i<T.RivejaKaytossa; i++){ KokoRivinLeveys[i] = 0; RivinLeveys[i] = 0; }
    
    for(int i=0; i<T.KirjaimiaKaytossa; i++)
        KokoRivinLeveys[T.EnkoodattuTeksti[i].Rivi] += Fontit[Fontti].Kirjaimet[T.EnkoodattuTeksti[i].Ind].Leveys * KokoKerroin;

    double *WKeskitys = new double [T.RivejaKaytossa];
    double HKeskitys;
    for(int i=0; i<T.RivejaKaytossa; i++)
    {
        switch(KeskitysTapa)
        {
            case AlaVasen: case KeskiVasen: case YlaVasen:
                WKeskitys[i] = 0;                       break;
                
            case AlaKeski: case KeskiKeski: case YlaKeski:
                WKeskitys[i] = -KokoRivinLeveys[i]/2;    break;
            
            case AlaOikea: case KeskiOikea: case YlaOikea:
                WKeskitys[i] = -KokoRivinLeveys[i];      break;
        }
    }
    switch(KeskitysTapa)
    {
        case AlaVasen: case AlaKeski: case AlaOikea:
            HKeskitys = 0;                                                        break;
                
        case KeskiVasen: case KeskiKeski: case KeskiOikea:
            HKeskitys = -T.RivejaKaytossa * Fontit[Fontti].Kirjaimet[0].Korkeus * KokoKerroin/2;   break;
            
        case YlaVasen: case YlaKeski: case YlaOikea:
            HKeskitys = -T.RivejaKaytossa * Fontit[Fontti].Kirjaimet[0].Korkeus * KokoKerroin;     break;
    }
    

    for(int i=0; i<T.KirjaimiaKaytossa; i++)
    {
        LisaaKuva( Fontit[Fontti].Kirjaimet[T.EnkoodattuTeksti[i].Ind],
                   X + RivinLeveys[T.EnkoodattuTeksti[i].Rivi] + WKeskitys[T.EnkoodattuTeksti[i].Rivi],
                   Y + (T.RivejaKaytossa - T.EnkoodattuTeksti[i].Rivi -1) * Fontit[Fontti].Kirjaimet[0].Korkeus * KokoKerroin + HKeskitys,
                   KokoKerroin, ColTeksti );
        RivinLeveys[T.EnkoodattuTeksti[i].Rivi] += Fontit[Fontti].Kirjaimet[T.EnkoodattuTeksti[i].Ind].Leveys * KokoKerroin;
    }
    
    delete [] WKeskitys;
    delete [] KokoRivinLeveys;
    delete [] RivinLeveys;

    delete [] T.EnkoodattuTeksti; T.EnkoodattuTeksti = NULL;
}
    



void TEKSTI::Alku()
{
    EnkoodattuTeksti = new ENKOODATTU [10000];

    for(int i=0; i<RivienLKM; i++)
    {
        KohtiaKaytossaRivilla[i] = 0;
    }
    RivejaKaytossa = 0;
    KirjaimiaKaytossa = 0;
    ValittaviaKohtiaKaytossa = 0;
}

void TEKSTI::Lisaa( char *Kohta, int Rivi, bool Valittava )
{
    if(Rivi+1 > RivejaKaytossa)
        RivejaKaytossa = Rivi+1;
    
    for(int i=0; i<strlen(Kohta); i++)
    {
        for(int n=32; n<256; n++)
        {
            if(Kohta[i] == Merkit[n])
            {
                EnkoodattuTeksti[KirjaimiaKaytossa].Ind = n;
                EnkoodattuTeksti[KirjaimiaKaytossa].Rivi = Rivi;
                EnkoodattuTeksti[KirjaimiaKaytossa].Kohta = KohtiaKaytossaRivilla[Rivi];
                KirjaimiaKaytossa++;
                break;
            }
        }
    }
    
    if(Valittava)
    {
        ValittavaKohta[ValittaviaKohtiaKaytossa].Rivi = Rivi;
        ValittavaKohta[ValittaviaKohtiaKaytossa].Kohta = KohtiaKaytossaRivilla[Rivi];
        ValittavaKohta[ValittaviaKohtiaKaytossa].KirjainKohdistettu = -1;
        ValittaviaKohtiaKaytossa++;
    }
    KohtiaKaytossaRivilla[Rivi]++;
}

int TEKSTI::ValittuKohta(unsigned int ValittuKohtaInd)
{
    return ValittavaKohta[ValittuKohtaInd].KirjainKohdistettu;
}



FONTTI &GRAFIIKKA::Fontti()
{
    return Fontit[0];
}

    
void GRAFIIKKA::AlustaFontit()
{
    int Leveydet[257];
    
    FonttienLKM = 1;
    Fontit = new FONTTI [FonttienLKM];

    Fontit[0].Alusta( "Fontti", "Tiedostot\\Fontit\\MerkkienLeveydet.txt");
    
    
}



void FONTTI::Alusta( char *Nimi, char *TiedostoNimi )
{
    int Leveydet[257];
    LataaFontinLeveydet( TiedostoNimi, Leveydet );

    float TexLeveys = Leveydet[0];
    float MerkinH = 1.0/16.0;
    
    for(int RiviInd=0; RiviInd<16; RiviInd++)
    {
        for(int SarakeInd=0; SarakeInd<16; SarakeInd++)
        {
            int i = (15-RiviInd)*16 + SarakeInd;
            float MerkinW = (float)Leveydet[i+1]/TexLeveys; 
            
            Kirjaimet[i].Alusta( Nimi, TexLeveys * MerkinW, TexLeveys * MerkinH,
                                 (float)SarakeInd/16.0, (float)RiviInd/16.0, MerkinW, MerkinH );
        }
    }
}






